% This file verifies the sum: \sum_{n=2}^\infty \frac{\sin^2\pi\mu n}{n^2(1+n^{2p})}, 
% where cyclic ratio mu should be in (0,1). The calculation is carried out in 2 different ways: 
% brute numerical summation and exact residue-based method, respectively denoted by answ1 and answ2.
%
% Author: Iaroslav V. Blagouchine, first version of this file was written in August 2010.  


function [answ1,answ2]=sumsin2articleoneinfty(mu,p,nmax)

if nargin<3
	nmax=1e4;
end

if nargin<2
	p=1;
end

if nargin<1
	mu=0.5;
end



%Computation via direct numeric summation
n=2:nmax;
fn=(sin(pi*mu*n).^2)./((1+n.^(2*p)).*n.^2);
answ1=sum(fn);


% Computaion via analytical method of residues
% Exact analytical method
% Computation of the poles
l=0:2*p-1;
zp=exp(i*pi*(2*l+1)/(2*p));

% Residues of the first sum.
for s1=1:2*p
	% Product without crossed term
	prpart1=zp(s1)-zp;
	prpart1(s1)=1;
	pr1(s1)=1/prod(prpart1);
	% Residue at the point z_s:
	tmp1(s1)=pr1(s1)*ctg(pi*zp(s1))/zp(s1)^2;
end
% Sum of the residues of the first sum.
sumres1=sum(tmp1);

% Residues of the second sum.
for s=1:2*p
	% Product without crossed term
	prpart=zp(s)-zp;
	prpart(s)=1;
	pr(s)=1/prod(prpart);
	% Residue at the point z_s:
	tmp(s,:)=pr(s)*exp(i*pi*(2*mu-1)*zp(s))/(sin(pi*zp(s))*zp(s)^2);
end
% Sum of the residues
sumres2=real(sum(tmp,1));

% Final result
answ2=(-pi/4)*sumres1 + (pi/4)*sumres2 + 0.5*pi^2.*mu.*(1-mu) - 0.5*(sin(pi*mu)).^2;
% To get rid of a very small imaginary part which appears because of Matlab issues.
answ2=real(answ2);

% If one wishes to verify particular cases
% p=1;
%answ3=pi*(ch(pi*(2*mu-1))/sh(pi)-cth(pi))/4 + 0.5*pi^2.*mu.*(1-mu) - 0.5*(sin(pi*mu)).^2;