% This file verifies the sum: \sum_{n=-\infty}^{+\infty} \frac{\sin{\alpha n}}{(n-\varepsilon)^2} 
% where parameter alpha should be in (0,2*pi). To ensure verification in all possible cases,
% parameters alpha and epsilon are randomly chosen in the specified intervals. 
% The calculation is carried out in 2 different ways: brute numerical summation 
% and exact residue-based method, respectively denoted by answ1 and answ2.
%
% Author: Iaroslav V. Blagouchine, first version of this file was written in July 2010. 

function [answ1,answ2]=sum300311bis(alfa,eps,nmax)

if nargin<3
	nmax=1e3;
end

if nargin<2
	eps=3*rand
end

if nargin<1
	alfa=2*pi*rand
end


% Computation via direct numeric summation
n=-nmax:nmax;
fn=sin(alfa*n)./(n-eps).^2;
answ1=sum(fn);

% Computaion via analytical method of residues
answ2=pi*sin(eps*(alfa-pi))*((pi-alfa)*ctg(eps*(alfa-pi))+pi*ctg(pi*eps))/sin(pi*eps);